package com.example.sefinsa_app.models;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

public class Folio implements Parcelable {

    public String id;
    public String fecha;
    public String hora;
    public String cliente_id;
    public String ruta_id;
    public String poblacion_id;
    public String colocadora_id;
    public String monto;
    public String monto_letra;
    public String concepto;
    public String firma_usuario;
    public String firma_cliente;
    public String sync;

    public Folio(String id,
                 String fecha,
                 String hora,
                 String cliente_id,
                 String ruta_id,
                 String poblacion_id,
                 String colocadora_id,
                 String monto,
                 String monto_letra,
                 String concepto,
                 String firma_usuario,
                 String firma_cliente
    ) {
        this.id = id;
        this.fecha = fecha;
        this.hora = hora;
        this.cliente_id = cliente_id;
        this.ruta_id = ruta_id;
        this.poblacion_id = poblacion_id;
        this.colocadora_id = colocadora_id;
        this.monto = monto;
        this.monto_letra = monto_letra;
        this.concepto = concepto;
        this.firma_usuario = firma_usuario;
        this.firma_cliente = firma_cliente;
    }

    public Folio(Parcel in) {
        id = in.readString();
        fecha = in.readString();
        hora = in.readString();
        cliente_id = in.readString();
        ruta_id = in.readString();
        poblacion_id = in.readString();
        colocadora_id = in.readString();
        monto = in.readString();
        monto_letra = in.readString();
        concepto = in.readString();
        firma_usuario = in.readString();
        firma_cliente = in.readString();
    }


    public static final Creator<Folio> CREATOR = new Creator<Folio>() {
        @Override
        public Folio createFromParcel(Parcel in) {
            return new Folio(in);
        }

        @Override
        public Folio[] newArray(int size) {
            return new Folio[size];
        }
    };

    public Folio(String folioId,
                 String fecha,
                 String hora,
                 String nombreCliente,
                 String ruta,
                 String poblacion,
                 String monto,
                 String montoLetra,
                 String concepto,
                 String firmaUsuario,
                 String firmaCliente) {
        this.id = folioId;
        this.fecha = fecha;
        this.hora = hora;
        this.cliente_id = nombreCliente;
        this.ruta_id = ruta;
        this.poblacion_id = poblacion;
        this.monto = monto;
        this.monto_letra = montoLetra;
        this.concepto = concepto;
        this.firma_usuario = firmaUsuario;
        this.firma_cliente = firmaCliente;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeString(fecha);
        dest.writeString(hora);
        dest.writeString(cliente_id);
        dest.writeString(ruta_id);
        dest.writeString(poblacion_id);
        dest.writeString(colocadora_id);
        dest.writeString(monto);
        dest.writeString(monto_letra);
        dest.writeString(concepto);
        dest.writeString(firma_usuario);
        dest.writeString(firma_cliente);
    }

    public String getId() { return id; }
    public void setId(String id) { this.id = id; }
    public String getFecha() { return fecha; }
    public void setFecha(String fecha) { this.fecha = fecha; }
    public String getHora() { return hora; }
    public void setHora(String hora) { this.hora = hora; }
    public String getCliente_id() { return cliente_id; }
    public void setCliente_id(String cliente_id) { this.cliente_id = cliente_id; }
    public String getRuta_id() { return ruta_id; }
    public void setRuta_id(String ruta_id) { this.ruta_id = ruta_id; }
    public String getPoblacion_id() { return poblacion_id; }
    public void setPoblacion_id(String poblacion_id) { this.poblacion_id = poblacion_id; }
    public String getColocadora_id() { return colocadora_id; }
    public void setColocadora_id(String colocadora_id) { this.colocadora_id = colocadora_id; }
    public String getMonto() { return monto; }
    public void setMonto(String monto) { this.monto = monto; }
    public String getMonto_letra() { return monto_letra; }
    public void setMonto_letra(String monto_letra) { this.monto_letra = monto_letra; }
    public String getConcepto() { return concepto; }
    public void setConcepto(String concepto) { this.concepto = concepto; }
    public String getFirma_usuario() { return firma_usuario; }
    public void setFirma_usuario(String firma_usuario) { this.firma_usuario = firma_usuario; }
    public String getFirma_cliente() { return firma_cliente; }
    public void setFirma_cliente(String firma_cliente) { this.firma_cliente = firma_cliente; }
    public String getSync() { return sync; }
    public void setSync(String sync) { this.sync = sync; }

    @NonNull
    @Override
    public String toString() {
        return "Folio{" +
                "id='" + id + '\'' +
                ", fecha='" + fecha + '\'' +
                ", hora='" + hora + '\'' +
                ", cliente_id='" + cliente_id + '\'' +
                ", ruta_id='" + ruta_id + '\'' +
                ", poblacion_id='" + poblacion_id + '\'' +
                ", colocadora_id='" + colocadora_id + '\'' +
                ", monto='" + monto + '\'' +
                ", monto_letra='" + monto_letra + '\'' +
                ", concepto='" + concepto + '\'' +
                '}';
    }
}
